//
//		Definition of the main game class
//
#ifndef THE_SLICED_VARIABLE_METER_H
#define THE_SLICED_VARIABLE_METER_H


#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"

class ldwButton;


class theGameState;
class ldwTextControl;

//CLASS DEFINES
//#define cMeterThickness 23
#define cSlMeterFullWidth 256
#define cSlTSMeterFullWidth 270
//#define cMeterFrameXOffset 7
//#define cMeterFrameYOffset 5
//#define cMeterTransparency 0.9f
#define cMeterSliceWidth 16
#define cVdXPos 462
#define cVdFarmYPos 223
#define cVdConstructYPos 265
#define cVdResearchYPos 308
#define cVdHealYPos 351
#define cVdBreedYPos 392
#define cVdHealthYPos 94
#define cTSXL 93
#define cTSXR 422
#define cTSYFarmMedPos 158
#define cTSYFertBuildPos 294
#define cTSYSciSpiritPos 431
 
//...typedefs etc


typedef enum
{
	eSlRedMeter,
	eSlGreenMeter,
	eSlBlueMeter,
	eSlVdFarming,
	eSlVdConstruction,
	eSlVdResearch,
	eSlVdHealing,
	eSlVdBreeding,
	eSlVdHealth,
	eSlNoMeter
} SlMeterColorEnum;	



//END DEFINES

//BEGIN CLASS DECLARATION
class theSlicedVariableMeter 
{
public:

	static theSlicedVariableMeter * Get();
	static void Destroy();

	theSlicedVariableMeter();
	~theSlicedVariableMeter();
	void DrawPercentMeter(SlMeterColorEnum flavor, int fillPercent);

protected:
	


	static theSlicedVariableMeter *mInstance;
private:
    
	ldwGameWindow *gameWindow;
	theGameState  *gs;
	ldwImage *bambooMeterFrame;
	ldwImage *statusSliceB;
	ldwImage *statusSliceR;
	ldwImage *thermomBulb;
};
#endif